package com.ejie.ab04b.validation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.service.ComunicacionAperturaService;
import com.ejie.ab04b.service.CoordinadorObraService;
import com.ejie.ab04b.service.DatosAvisoService;
import com.ejie.ab04b.service.PromotorService;
import com.ejie.ab04b.util.Utilities;

/**
 * Clase encargada de las validaciones para denuncias temporales
 * 
 * @author GFI-NORTE
 */
@Component()
public final class ComunicacionAperturaValidator extends
		AbstractValidator<ComunicacionApertura> {

	@Autowired()
	private PromotorService promotorService;
	@Autowired()
	private CoordinadorObraService coordinadorObraService;

	@Autowired()
	private DatosAvisoService datosAvisoService;

	@Autowired()
	private ComunicacionAperturaService comunicAperturaService;

	/**
	 * Method 'DenunciaValidator'.
	 */
	private ComunicacionAperturaValidator() {
		super();
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabProcAlmac(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		// // descripcion maquinaria
		// if (comunicacionApertura.getDescmaq056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.maquinaria",
		// "validacion.obligatorio"));
		// }
		//
		// // potencia instalada
		// if (comunicacionApertura.getPoten056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.potencia",
		// "validacion.obligatorio"));
		// }
		//
		// if (comunicacionApertura.getIndanx056() != null &&
		// Constantes.VALUE_SI
		// .equals(comunicacionApertura.getIndanx056())) {
		// if (comunicacionApertura.getApdoanx056() == null) {
		// errorFields
		// .add(new ErrorField("aperturas.detalle.trabajoAnexoI",
		// "validacion.obligatorio"));
		// }
		// }

	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabDatosObra(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {
		if (comunicacionApertura.getObra() != null) {

			if (comunicacionApertura.getCodobra056() != null) {
				comunicacionApertura.getObra().setCodobra082(
						comunicacionApertura.getCodobra056());
			}
			Obra obra = comunicacionApertura.getObra();

			// if (obra.getTipobr082() == null) {
			// errorFields.add(new ErrorField("aperturas.detalle.tipoObra",
			// "validacion.obligatorio"));
			// }
			// if (obra.getFecini082() == null) {
			// errorFields
			// .add(new ErrorField("aperturas.detalle.fecIniPrevObra",
			// "validacion.obligatorio"));
			// }
			// if (obra.getDurpre082() == null || obra.getUnitmp082() == null) {
			// errorFields.add(new ErrorField("aperturas.detalle.durPreObra",
			// "validacion.obligatorio"));
			// }
			// if (obra.getTrbtot082() == null) {
			// errorFields.add(new ErrorField("aperturas.detalle.numTrab.tot",
			// "validacion.obligatorio"));
			// } else if ((obra.getTrbhom082() != null
			// && obra.getTrbmuj082() != null
			// && (obra.getTrbhom082() + obra.getTrbmuj082()) != obra
			// .getTrbtot082())) {
			// errorFields.add(new ErrorField("aperturas.detalle.numTrab.tot",
			// "error.sumaTrabajadoresObra"));
			// }
			if (obra.getPrvobr082() == null) {
				errorFields.add(new ErrorField("aperturas.territorio",
						"validacion.obligatorio"));
			}
			// if (obra.getMunobr082() == null) {
			// errorFields.add(new ErrorField("aperturas.municipio",
			// "validacion.obligatorio"));
			// }
			// if (obra.getLocobr082() == null) {
			// errorFields.add(new ErrorField("aperturas.detalle.localidad",
			// "validacion.obligatorio"));
			// }
			// if (obra.getDirobr082() == null) {
			// errorFields.add(new ErrorField("aperturas.detalle.direccion",
			// "validacion.obligatorio"));
			// }
			// if (obra.getIndanx2082() != null
			// && Constantes.VALUE_SI.equals(obra.getIndanx2082())) {
			// if (obra.getApdoanx2082() == null) {
			// errorFields.add(
			// new ErrorField("aperturas.detalle.trabajoAnexoII",
			// "validacion.obligatorio"));
			// }
			// }
		}
		if ((comunicacionApertura.getRegemp1() == null
				|| comunicacionApertura.getRegemp2() == null || comunicacionApertura
				.getRegemp3() == null)
				&& comunicacionApertura.getRegemp056() == null) {
			errorFields.add(new ErrorField(
					"aperturas.detalle.registroEmprAcred",
					"validacion.obligatorio"));
		}
		if (comunicacionApertura.getPlanseg056() != null
				&& Constantes.VALUE_SI.equals(comunicacionApertura
						.getPlanseg056())
				&& comunicacionApertura.getCanalplan056() == null) {
			errorFields.add(new ErrorField(
					"aperturas.detalle.canalPresentacion.plan",
					"validacion.obligatorio"));
		}
		if (comunicacionApertura.getEvalpres056() != null
				&& Constantes.VALUE_SI.equals(comunicacionApertura
						.getEvalpres056())
				&& comunicacionApertura.getCanaleval056() == null) {
			errorFields.add(new ErrorField(
					"aperturas.detalle.canalPresentacion.eval",
					"validacion.obligatorio"));
		}
		if (comunicacionApertura.getNumcnt056() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.numContratistas",
					"validacion.obligatorio"));
		}

		Promotor promotorFind = new Promotor();
		promotorFind.setAnoexp085(comunicacionApertura.getAnoape056());
		promotorFind.setNumexp085(comunicacionApertura.getNumape056()
				.intValue());
		promotorFind.setTerexp085(comunicacionApertura.getTerape056());
		promotorFind.setCodobra085(comunicacionApertura.getCodobra056());
		List<Promotor> listaPromotores = this.promotorService.findAll(
				promotorFind, null);

		if (listaPromotores == null || listaPromotores.isEmpty()) {
			errorFields.add(new ErrorField("aperturas.detalle.promotores",
					"error.ningunPromotorObra"));
		} else {
			promotorFind.setTipoprm085(Constantes.PROMOTOR_PRINCIPAL);
			if (this.promotorService.buscarHayPromotorPrincipal(promotorFind) <= 0) {
				errorFields.add(new ErrorField("aperturas.detalle.promotores",
						"error.ningunPromotorPrincipal"));
			}
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabDatosCentro(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		// // tipo apertura
		// if (comunicacionApertura.getTipoApertura() == null
		// || comunicacionApertura.getTipoApertura()
		// .getTipape071() == null) {
		// errorFields.add(new ErrorField("aperturas.tiposAperturas",
		// "validacion.obligatorio"));
		// }
		//
		// // desc obra
		// if (comunicacionApertura.getNomctr056() == null) {
		// errorFields
		// .add(new ErrorField("aperturas.detalle.nomCentroDescObra",
		// "validacion.obligatorio"));
		// }

		// datos domicilio centro
		if (comunicacionApertura.getProvinciaCtr() == null
				|| comunicacionApertura.getProvinciaCtr().getCodProvincia() == null) {
			errorFields.add(new ErrorField("aperturas.territorio",
					"validacion.obligatorio"));
		}
		// if (comunicacionApertura.getMunicipioCtr() == null
		// || comunicacionApertura.getMunicipioCtr()
		// .getCodMunicipio() == null) {
		// errorFields.add(new ErrorField("aperturas.municipio",
		// "validacion.obligatorio"));
		// }
		// if (comunicacionApertura.getDirctr056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.direccion",
		// "validacion.obligatorio"));
		// }
		// if (comunicacionApertura.getCpoctr056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.cp",
		// "validacion.obligatorio"));
		// }
		// if (comunicacionApertura.getTlfctr056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.telef",
		// "validacion.obligatorio"));
		// }
		//
		// // fecha inicio actividad
		// if (comunicacionApertura.getFecini056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.fecIniActividad",
		// "validacion.obligatorio"));
		// }
		if (!Utilities.getInstance().esCooperativa(
				comunicacionApertura.getNumdoc056())) {
			// numero seguridad social centro
			if (comunicacionApertura.getPrvss056() != null
					&& comunicacionApertura.getPrvss056().length() < ConstantesNum.NUM_2) {
				errorFields.add(new ErrorField("aperturas.detalle.nss.prov",
						"error.longitud", String.valueOf(ConstantesNum.NUM_2)));
			}
			if (comunicacionApertura.getNumss056() != null
					&& comunicacionApertura.getNumss056().length() < ConstantesNum.NUM_8) {
				errorFields.add(new ErrorField("aperturas.detalle.nss.nro",
						"error.longitud", String.valueOf(ConstantesNum.NUM_8)));
			}
			if (comunicacionApertura.getDigss056() != null
					&& comunicacionApertura.getDigss056().length() < ConstantesNum.NUM_2) {
				errorFields.add(new ErrorField("aperturas.detalle.nss.dig",
						"error.longitud", String.valueOf(ConstantesNum.NUM_2)));

			}
			// if (comunicacionApertura.getPrvss056() != null
			// && comunicacionApertura.getNumss056() != null
			// && comunicacionApertura.getDigss056() != null
			// && !ValidadorNumSS.isNSSValido(comunicacionApertura
			// .getPrvss056()
			// + comunicacionApertura.getNumss056()
			// + comunicacionApertura.getDigss056())) {
			// errorFields.add(new ErrorField("aperturas.detalle.numSS",
			// "error.nss.incorrecto"));
			// }
			if (comunicacionApertura.getPrvss056() == null
					|| comunicacionApertura.getNumss056() == null
					|| comunicacionApertura.getDigss056() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.numSS",
						"validacion.obligatorio"));
			}
		}
		if (comunicacionApertura.getTrbhom056() != null
				&& comunicacionApertura.getTrbmuj056() != null
				&& comunicacionApertura.getTrbtot056() != null
				&& ((comunicacionApertura.getTrbhom056() + comunicacionApertura
						.getTrbmuj056()) != comunicacionApertura.getTrbtot056())) {
			errorFields.add(new ErrorField("aperturas.detalle.numTrabOcupados",
					"error.sumaTrabajadoresObra"));
		}

		// if (comunicacionApertura.getClasctr056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.claseCentro",
		// "validacion.obligatorio"));
		// }
		//
		// if (comunicacionApertura.getCnaectr056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.cnaeEmp",
		// "validacion.obligatorio"));
		// }
		if (comunicacionApertura.getModpre056() == null
				|| comunicacionApertura.getModpre056() == 0) {
			errorFields.add(new ErrorField(
					"aperturas.detalle.modalidadOrgPrev",
					"validacion.obligatorio"));
		}

		if (comunicacionApertura.getAsgosl056() != null
				&& comunicacionApertura.getAsgosl056().equals(
						Constantes.VALUE_SI)) {
			if (comunicacionApertura.getTecosl056() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.tecnico",
						"validacion.obligatorio"));
			}
			if (comunicacionApertura.getFvisosl056() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.fecVisita",
						"validacion.obligatorio"));
			}
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabNotificacion(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		// descripcion maquinaria
		if (comunicacionApertura.getDatosNotificacion() != null) {

			DatosNotificacion datosNotificacion = comunicacionApertura
					.getDatosNotificacion();

			if (datosNotificacion.getIdioma066() == null) {
				errorFields.add(new ErrorField("idioma",
						"validacion.obligatorio"));
			}

			DatosAviso datosAvisoFind = new DatosAviso();
			datosAvisoFind.setDatosNotificacion(datosNotificacion);
			List<DatosAviso> listaDatosAviso = this.datosAvisoService.findAll(
					datosAvisoFind, null);
			if (listaDatosAviso == null || listaDatosAviso.isEmpty()) {
				errorFields.add(new ErrorField("aperturas.detalle.datosAviso",
						"error.ningunDatoAviso"));
			}

			if (datosNotificacion.getCanalnotif066() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.canalNotif",
						"validacion.obligatorio"));
			} else if (Constantes.CANAL_NOTIF_POSTAL.equals(datosNotificacion
					.getCanalnotif066())) {
				if (datosNotificacion.getDatosLocalizacion() == null) {
					errorFields.add(new ErrorField("canalNotif.postal",
							"error.ningunDatoLocalizacion"));
				} else {
					DatosLocalizacion datosLocalizacion = datosNotificacion
							.getDatosLocalizacion();

					if (datosLocalizacion.getProvincia() == null
							|| datosLocalizacion.getProvincia()
									.getCodProvincia() == null) {
						errorFields.add(new ErrorField("aperturas.territorio",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getMunicipio() == null
							|| datosLocalizacion.getMunicipio()
									.getCodMunicipio() == null) {
						errorFields.add(new ErrorField("aperturas.municipio",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getLocalidad() == null
							|| datosLocalizacion.getLocalidad()
									.getCodLocalidad() == null) {
						errorFields.add(new ErrorField(
								"aperturas.detalle.localidad",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getCalle067() == null) {
						errorFields.add(new ErrorField(
								"aperturas.detalle.calle",
								"validacion.obligatorio"));
					}
					if (datosLocalizacion.getCodpostal067() == null) {
						errorFields.add(new ErrorField("aperturas.detalle.cp",
								"validacion.obligatorio"));
					}

					if (datosLocalizacion.getLocalidad() != null
							&& datosLocalizacion.getLocalidad()
									.getCodLocalidad() != null
							&& datosLocalizacion.getCodpostal067() != null) {
						this.validateLocalidadCP(errorFields,
								comunicacionApertura);
					}
				}
			}

		}

		// datos de contacto

		// if (Utilities.getInstance().isEmpty(
		// comunicacionApertura.getTelefContactoSolic056()) &&
		// Utilities.getInstance().isEmpty(
		// comunicacionApertura.getMailContactoSolic056())) {
		// errorFields.add(new ErrorField("datoscontacto.title",
		// "error.ningunDatoContacto")); } else {
		if (!Utilities.getInstance().isEmpty(
				comunicacionApertura.getTelefContactoSolic056())
				&& (!comunicacionApertura.getTelefContactoSolic056().matches(
						"[0-9]+") || comunicacionApertura
						.getTelefContactoSolic056().length() > ConstantesNum.NUM_11)) {
			errorFields.add(new ErrorField("datoscontacto.title",
					"error.telefono"));
		}

		if (!Utilities.getInstance().isEmpty(
				comunicacionApertura.getMailContactoSolic056())
				&& !Utilities.getInstance().compruebaEmail(
						comunicacionApertura.getMailContactoSolic056())) {
			errorFields.add(new ErrorField("datoscontacto.title",
					"error.mail.invalido"));
		}
		// }

	}

	/**
	 * Valida que el CP pertenezca a la localidad
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateLocalidadCP(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		if (!this.comunicAperturaService
				.validaLocalidadCP(comunicacionApertura)) {
			errorFields.add(new ErrorField("aperturas.detalle.cp",
					"error.cp.localidad"));
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabDatosEmpresa(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		// obra
		// if (comunicacionApertura.getIndobra056() == null) {
		// errorFields.add(new ErrorField(
		// "aperturas.detalle.indobraExistente",
		// "validacion.obligatorio"));
		// }
		// // codigo de centro
		// if (comunicacionApertura.getIndobra056() != null &&
		// Constantes.VALUE_NO
		// .equals(comunicacionApertura.getIndobra056())) {
		// if (comunicacionApertura.getCodctr056() == null
		// || comunicacionApertura.getCodctr056() == 0) {
		// errorFields.add(new ErrorField("aperturas.detalle.codCentro",
		// "validacion.obligatorio"));
		// }
		// }
		// tipo identificacion
		if (comunicacionApertura.getTipdoc056() == null) {
			errorFields.add(new ErrorField("aperturas.tipoidentif",
					"validacion.obligatorio"));
		}
		// numero identificacion
		if (comunicacionApertura.getNumdoc056() == null) {
			errorFields.add(new ErrorField("aperturas.numdoc",
					"validacion.obligatorio"));
		}
		// nombre empresa
		if (comunicacionApertura.getNomemp056() == null) {
			errorFields.add(new ErrorField("aperturas.nombreEmpresa",
					"validacion.obligatorio"));
		}
		// // pais
		// if (comunicacionApertura.getPaisemp056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.pais",
		// "validacion.obligatorio"));
		// }
		// if (comunicacionApertura.getPaisemp056() != null
		// && Constantes.ID_PAIS_ESPANA
		// .equals(comunicacionApertura.getPaisemp056())) {
		// // territorio
		// if (comunicacionApertura.getProvinciaEmp() == null
		// || comunicacionApertura.getProvinciaEmp()
		// .getCodProvincia() == null) {
		// errorFields.add(new ErrorField("aperturas.territorio",
		// "validacion.obligatorio"));
		// }
		// // municipio
		// if (comunicacionApertura.getMunicipioEmp() == null
		// || comunicacionApertura.getMunicipioEmp()
		// .getCodMunicipio() == null) {
		// errorFields.add(new ErrorField("aperturas.municipio",
		// "validacion.obligatorio"));
		// }
		// } else if (comunicacionApertura.getPaisemp056() != null
		// && !Constantes.ID_PAIS_ESPANA
		// .equals(comunicacionApertura.getPaisemp056())) {
		// // municipio extranjero
		// if (comunicacionApertura.getDmunemp056() == null) {
		// errorFields
		// .add(new ErrorField("aperturas.detalle.munipExtranjero",
		// "validacion.obligatorio"));
		// }
		// }
		// direccion
		if (comunicacionApertura.getDiremp056() == null) {
			errorFields.add(new ErrorField("aperturas.detalle.direccion",
					"validacion.obligatorio"));
		}
		// // codigo postal
		// if (comunicacionApertura.getCpoemp056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.cp",
		// "validacion.obligatorio"));
		// }
		// telefono
		// if (comunicacionApertura.getTlfemp056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.telef",
		// "validacion.obligatorio"));
		// }
		// // cnae
		// if (comunicacionApertura.getCnaeemp056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.cnaeEmp",
		// "validacion.obligatorio"));
		// }
		// // entidad gestora
		// if (comunicacionApertura.getCodentiat056() == null) {
		// errorFields.add(new ErrorField("aperturas.detalle.entidadGestCol",
		// "validacion.obligatorio"));
		// }
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateMarcarVisitaOsalan(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {

		if (comunicacionApertura.getAsgosl056() != null
				&& comunicacionApertura.getAsgosl056().equals(
						Constantes.VALUE_SI)) {
			if (comunicacionApertura.getTecosl056() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.tecnico",
						"validacion.obligatorio"));
			}
			if (comunicacionApertura.getFvisosl056() == null) {
				errorFields.add(new ErrorField("aperturas.detalle.fecVisita",
						"validacion.obligatorio"));
			}
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> comunicacionApertura ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param comunicacionApertura
	 *            the comunicacion apertura
	 */
	@Override()
	protected void validateEditTabCoordinadores(List<ErrorField> errorFields,
			ComunicacionApertura comunicacionApertura) {
		CoordinadorObra coordFind = new CoordinadorObra();
		coordFind.setAnoexp084(comunicacionApertura.getAnoape056());
		coordFind.setNumexp084(comunicacionApertura.getNumape056().intValue());
		coordFind.setTerexp084(comunicacionApertura.getTerape056());
		coordFind.setCodobra084(comunicacionApertura.getCodobra056());
		coordFind.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);

		List<CoordinadorObra> listaCoordinadores = this.coordinadorObraService
				.findAll(coordFind, null);

		if (listaCoordinadores == null || listaCoordinadores.isEmpty()) {
			errorFields.add(new ErrorField("aperturas.detalle.coordinadores",
					"error.ningunCoordinadorE"));
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> filtro ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param filtro
	 *            the filtro
	 */
	@Override()
	protected void validatefilterListAnualMesTer(List<ErrorField> errorFields,
			ComunicacionApertura filtro) {

		// anyo
		if (filtro.getAnoape056() == null) {
			errorFields.add(new ErrorField("aperturas.anyo",
					"validacion.obligatorio"));
		}
	}

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 * errorFields List<ErrorField> filtro ComunicacionApertura
	 * 
	 * @param errorFields
	 *            the error fields
	 * @param filtro
	 *            the filtro
	 */
	@Override()
	protected void validatefilterListAnualSecTer(List<ErrorField> errorFields,
			ComunicacionApertura filtro) {

		// anyo
		if (filtro.getAnoape056() == null) {
			errorFields.add(new ErrorField("aperturas.anyo",
					"validacion.obligatorio"));
		}
		// agrupacion
		if (filtro.getAgrupacion() == null) {
			errorFields.add(new ErrorField("aperturas.agrupacion",
					"validacion.obligatorio"));
		}
	}

}